<?xml version="1.0" encoding="UTF-8"?>


<xsl:stylesheet version="1.0"


xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<xsl:output method='html' version='1.0' encoding='UTF-8' indent='yes'/>





<xsl:template match="/">


  <html>


  <head>


      <title><xsl:value-of select="/SPICErack/@filename"/></title>


  </head>


  <body>





    <table width="90%">


      <tr>


        <td align="center">


          <table>


            <tr>


              <td>


           <img src="Images/2chillies.jpg" title="" alt="Spice_icon" style="width: 75px; height: 58px;"></img>


              </td>


              <td>


            <big><big>SPICE Version=<xsl:value-of select="/SPICErack/@SPICE_version"/></big></big>


              </td>


              </tr>


          </table>


          </td>


        <td align="center">


          <big><big>Filename=<xsl:value-of select="/SPICErack/@filename"/></big></big>


        </td>


      </tr> 


      <tr>


        <td align="center">


          <big>Start-time=<xsl:value-of select="/SPICErack/@start_time"/></big>


        </td>


        <td align="center">


          <big>End-time=<xsl:value-of select="/SPICErack/@end_time"/></big>


        </td>


      </tr>


    </table>


        <table cellspacing="20" >


       <tr>


       <td valign="top">


         <h3>2d Detector Plot</h3>


         <img>


      <xsl:attribute name="src">


        <xsl:value-of select="/SPICErack/Header[1]/ImagePath[1]" />


      </xsl:attribute>         


    </img>


     </td>


     <td valign="top">


       <h3>Counter Information</h3>


       <table  border="1">


         <tr bgcolor="#ffffaa">


           <th align="left">Counter Name</th>


           <th align="left">Counts</th>


           <th align="left">Units</th>


	   <th align="left">Description</th>


         </tr>


         <xsl:for-each select="/SPICErack/Counters[1]/*">			


           <tr>


             <td><xsl:value-of select="name()"/></td>


             <td><xsl:value-of select="."/></td>


             <td><xsl:value-of select="@units"/></td>


	     <td><xsl:value-of select="@description"/></td>


           </tr>


         </xsl:for-each>


       </table>


     </td>


     </tr>


    </table>


    


    <table cellspacing="20">


     <tr>


     <td valign="top">


     <h3>Header Information</h3>  


    <table border="1">


      <tr bgcolor="#ffffaa">


        <th align="left">Header Name</th>


        <th align="left">Value</th>


      </tr>


      <xsl:for-each select="/SPICErack/Header[1]/*">


      <tr>


        <xsl:if test="name(.) != 'Comment'">


            <td><xsl:value-of select="name()"/></td>


            <td><xsl:value-of select="."/></td>


        </xsl:if>


      </tr>


      </xsl:for-each>


    </table>


     </td>


       </tr>


    </table>


    


    <table cellpadding="20">


      <tr>


      <td valign="top">


    <h3>Motor Positions</h3>


    <table border="1">


      <tr bgcolor="#ffffaa">


        <th align="left">Motor Name</th>


        <th align="left">Position (Val.)</th>


        <th align="left">Unit</th>


        <th align="left">Position (Str.)</th>


	<th align="left">Description</th>


      </tr>


      <xsl:for-each select="/SPICErack/Motor_Positions[1]/*">


        <tr>


          <td><xsl:value-of select="name()"/></td>


          <td><xsl:value-of select="."/></td>


          <td><xsl:value-of select="@units"/></td>


          <td><xsl:value-of select="@pos"/></td>


	  <td><xsl:value-of select="@description"/></td>


        </tr>


      </xsl:for-each>


    </table>


      </td>    


              <td valign="top">


          <h3>Parameter Positions</h3>


          <table border="1">


            <tr bgcolor="#ffffaa">


              <th align="left">Motor Name</th>


              <th align="left">Position (Val.)</th>


              <th align="left">Unit</th>


              <th align="left">Position (Str.)</th>


              <th align="left">Description</th>


            </tr>


            <xsl:for-each select="/SPICErack/Parameter_Positions[1]/*">


              <tr>


                <td><xsl:value-of select="name()"/></td>


                <td><xsl:value-of select="."/></td>


                <td><xsl:value-of select="@units"/></td>


                <td><xsl:value-of select="@pos"/></td>


                <td><xsl:value-of select="@description"/></td>


              </tr>


            </xsl:for-each>


          </table>


        </td>    


      </tr>


    </table>


    <table cellpadding="20">


      <tr>


        <td>


            <h3>Run Comments:</h3>


             <xsl:for-each select="/SPICErack/Header[1]/*">


                    <xsl:if test="name(.) = 'Comment'">


                          <xsl:value-of select="."/><br></br>


                    </xsl:if>


              </xsl:for-each>


        </td>


      </tr>


    </table>


   </body>


  </html>


</xsl:template>


</xsl:stylesheet>